import pandas as pd  
import numpy as np
from sklearn.preprocessing import StandardScaler 
import pickle
from decision_company import read_csv_file, select_data_types, get_columns, df_copy, get_min_value, get_max, get_first_n_rows, fetch_column, create_standard_scaler, fit_transform_standard_scaler, col_assign_val
  
  
# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Identify numerical variables  
numerical_columns = get_columns(select_data_types(credit_customers, ['number']))  
  
# Calculate the range of each numerical column  
ranges = {}  
for col in numerical_columns:  
    col_data = fetch_column(credit_customers, col)  
    ranges[col] = get_max(col_data) - get_min_value(col_data)  
  
# Check if normalization is necessary  
normalization_needed = False  
for col, range_ in ranges.items():  
    if range_ > 1:  
        normalization_needed = True  
        break  
  
# It's true:  
# Normalize the data using Standard Scaling  
if normalization_needed: 
    scaler = create_standard_scaler()  
    credit_customers_normalized = df_copy(credit_customers)  
    col_assign_val(credit_customers_normalized, numerical_columns, fit_transform_standard_scaler(scaler, credit_customers[numerical_columns]))
  
    print("Data after Standard Scaling:\n", get_first_n_rows(credit_customers_normalized))  
    pickle.dump(get_first_n_rows(credit_customers_normalized), open("./ref_result/credit_customers_normalized_head.pkl", "wb"))  
else:
    print("Normalization is not needed.")  
